<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BahanPraktik;

class AdminBahanController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $bahan = BahanPraktik::orderBy('id','desc')->get();
        return view('admin.bahan.index', compact('bahan'));
    }

    public function create()
    {
        if (!session('admin_id')) return redirect()->route('login');
        return view('admin.bahan.create');
    }

    public function store(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        BahanPraktik::create([
            'kode' => $r->input('kode'),
            'nama' => $r->input('nama'),
            'stok' => $r->input('stok') ?: 0,
            'satuan' => $r->input('satuan') ?: 'pcs',
            'keterangan' => $r->input('keterangan')
        ]);

        return redirect()->route('admin.bahan.index')->with('success', 'Bahan berhasil ditambahkan');
    }

    public function edit($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $row = BahanPraktik::findOrFail($id);
        return view('admin.bahan.edit', compact('row'));
    }

    public function update(Request $r, $id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $b = BahanPraktik::findOrFail($id);
        $b->update([
            'kode' => $r->kode,
            'nama' => $r->nama,
            'stok' => $r->stok,
            'satuan' => $r->satuan,
            'keterangan' => $r->keterangan
        ]);

        return redirect()->route('admin.bahan.index')->with('success', 'Bahan berhasil diupdate');
    }

    public function destroy($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        BahanPraktik::findOrFail($id)->delete();
        return back()->with('success', 'Bahan berhasil dihapus');
    }
}