<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Inventaris;
use App\Models\KategoriInventaris;

class AdminInventarisController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $inventaris = Inventaris::with('kategori')->orderBy('id','desc')->get();
        return view('admin.inventaris.index', compact('inventaris'));
    }

    public function create()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $kategori = KategoriInventaris::orderBy('nama')->get();
        return view('admin.inventaris.create', compact('kategori'));
    }

    public function store(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Inventaris::create([
            'kode_barang' => $r->input('kode_barang'),
            'nama_barang' => $r->input('nama_barang'),
            'id_kategori' => $r->input('id_kategori') ?: null,
            'jumlah' => (int) $r->input('jumlah'),
            'kondisi' => $r->input('kondisi') ?: 'Baik',
            'lokasi' => $r->input('lokasi') ?: 'Laboratorium TKJT',
            'keterangan' => $r->input('keterangan')
        ]);

        return redirect()->route('admin.inventaris.index')->with('success', 'Inventaris berhasil ditambahkan');
    }

    public function edit($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $row = Inventaris::findOrFail($id);
        $kategori = KategoriInventaris::orderBy('nama')->get();
        return view('admin.inventaris.edit', compact('row','kategori'));
    }

    public function update(Request $r, $id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $i = Inventaris::findOrFail($id);
        $i->update([
            'kode_barang' => $r->input('kode_barang'),
            'nama_barang' => $r->input('nama_barang'),
            'id_kategori' => $r->input('id_kategori') ?: null,
            'jumlah' => (int) $r->input('jumlah'),
            'kondisi' => $r->input('kondisi') ?: $i->kondisi,
            'lokasi' => $r->input('lokasi') ?: $i->lokasi,
            'keterangan' => $r->input('keterangan')
        ]);

        return redirect()->route('admin.inventaris.index')->with('success', 'Inventaris berhasil diupdate');
    }

    public function destroy($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Inventaris::findOrFail($id)->delete();
        return back()->with('success', 'Inventaris berhasil dihapus');
    }
}