<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Siswa;

class AdminSiswaController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $siswa = Siswa::orderBy('id','desc')->get();
        return view('admin.siswa.index', compact('siswa'));
    }

    public function create()
    {
        if (!session('admin_id')) return redirect()->route('login');
        return view('admin.siswa.create');
    }

    public function store(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Siswa::create([
            'nis' => $r->input('nis'),
            'nama' => $r->input('nama'),
            'email' => $r->input('email'),
            'password' => $r->input('password'),
            'kelas' => $r->input('kelas'),
            'jurusan' => $r->input('jurusan') ?? 'TKJT',
            'telepon' => $r->input('telepon')
        ]);

        return redirect()->route('admin.siswa.index')->with('success', 'Siswa berhasil ditambahkan');
    }

    public function edit($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $row = Siswa::findOrFail($id);
        return view('admin.siswa.edit', compact('row'));
    }

    public function update(Request $r, $id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $s = Siswa::findOrFail($id);
        $s->update([
            'nis' => $r->input('nis'),
            'nama' => $r->input('nama'),
            'email' => $r->input('email'),
            'password' => $r->input('password') ?: $s->password,
            'kelas' => $r->input('kelas'),
            'jurusan' => $r->input('jurusan') ?? $s->jurusan,
            'telepon' => $r->input('telepon')
        ]);

        return redirect()->route('admin.siswa.index')->with('success', 'Siswa berhasil diupdate');
    }

    public function destroy($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Siswa::findOrFail($id)->delete();
        return back()->with('success', 'Siswa berhasil dihapus');
    }
}