<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Guru extends Model
{
    protected $table = 'guru';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'nip','nama','email','password','telepon','jabatan',
        'harus_setujui_sarpras'
    ];

    public function inventarisGuru()
    {
        return $this->hasMany(InventarisGuru::class, 'id_guru');
    }

    public function persetujuanSarpras()
    {
        return $this->hasMany(PersetujuanSarpras::class, 'id_guru');
    }

    public function pembimbingPenggunaanBahan()
    {
        return $this->hasMany(PenggunaanBahan::class, 'id_guru');
    }

    public function persetujuanPeminjaman()
    {
        return $this->hasMany(PeminjamanAlat::class, 'id_guru_persetujuan');
    }
}
