<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PeminjamanAlat extends Model
{
    protected $table = 'peminjaman_alat';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'kode_peminjaman','peminjam_id','peminjam_role',
        'id_guru_persetujuan','id_admin_verifikasi',
        'tanggal_pinjam','tanggal_kembali','status','alasan',
        'aturan_id','total_barang','denda'
    ];

    public function detail()
    {
        return $this->hasMany(PeminjamanDetail::class, 'peminjaman_id');
    }

    public function aturan()
    {
        return $this->belongsTo(AturanPeminjaman::class, 'aturan_id');
    }

    public function guruPersetujuan()
    {
        return $this->belongsTo(Guru::class, 'id_guru_persetujuan');
    }

    public function adminVerifikasi()
    {
        return $this->belongsTo(Admin::class, 'id_admin_verifikasi');
    }

    public function siswa()
    {
        return $this->belongsTo(Siswa::class, 'peminjam_id')
                    ->where('peminjam_role', 'siswa');
    }

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'peminjam_id')
                    ->where('peminjam_role', 'guru');
    }
}
