<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PenggunaanBahan extends Model
{
    protected $table = 'penggunaan_bahan';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'kode_penggunaan','id_siswa','id_guru',
        'tanggal','keterangan'
    ];

    public function siswa()
    {
        return $this->belongsTo(Siswa::class, 'id_siswa');
    }

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'id_guru');
    }

    public function detail()
    {
        return $this->hasMany(PenggunaanBahanDetail::class, 'penggunaan_id');
    }
}
