<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PenggunaanBahanDetail extends Model
{
    protected $table = 'penggunaan_bahan_detail';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'penggunaan_id','id_bahan','jumlah','satuan','keterangan'
    ];

    public function penggunaan()
    {
        return $this->belongsTo(PenggunaanBahan::class, 'penggunaan_id');
    }

    public function bahan()
    {
        return $this->belongsTo(BahanPraktik::class, 'id_bahan');
    }
}
