<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Siswa extends Model
{
    protected $table = 'siswa';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'nis','nama','email','password','kelas','jurusan','telepon'
    ];

    public function penggunaanBahan()
    {
        return $this->hasMany(PenggunaanBahan::class, 'id_siswa');
    }

    public function peminjamanAlat()
    {
        return $this->hasMany(PeminjamanAlat::class, 'peminjam_id')
                    ->where('peminjam_role', 'siswa');
    }
}
