@extends('layouts.admin')

@section('title', 'Koneksi API Sarpras')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Koneksi API Sarpras</h3>

    <div class="mb-3">
        <form action="{{ route('admin.api.sarpras.sync') }}" method="POST">
            @csrf
            <button type="submit" class="btn btn-success">
                <i class="fa fa-sync"></i> Sync Sekarang
            </button>
        </form>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Nama Aplikasi</th>
                        <th>Endpoint URL</th>
                        <th>Status</th>
                        <th>Last Sync</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($koneksi as $k)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $k->nama_aplikasi }}</td>
                        <td>{{ $k->endpoint_url }}</td>
                        <td>
                            <span class="badge {{ $k->aktif ? 'bg-success' : 'bg-secondary' }}">
                                {{ $k->aktif ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>{{ $k->last_sync ? $k->last_sync->format('d-m-Y H:i') : '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
@endpush
@endsection
