@extends('admin.layout')

@section('content')
<div class="container py-4">

    <h4 class="fw-bold mb-3">Edit Bahan Praktik</h4>

    <div class="card shadow-sm">
        <div class="card-body">

            <form action="{{ route('admin.bahan.update', $row->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label>Kode Bahan</label>
                    <input type="text" name="kode" class="form-control"
                           value="{{ $row->kode }}" required>
                </div>

                <div class="mb-3">
                    <label>Nama Bahan</label>
                    <input type="text" name="nama" class="form-control"
                           value="{{ $row->nama }}" required>
                </div>

                <div class="mb-3">
                    <label>Stok</label>
                    <input type="number" name="stok" class="form-control"
                           value="{{ $row->stok }}">
                </div>

                <div class="mb-3">
                    <label>Satuan</label>
                    <input type="text" name="satuan" class="form-control"
                           value="{{ $row->satuan }}">
                </div>

                <div class="mb-3">
                    <label>Keterangan</label>
                    <textarea name="keterangan" class="form-control" rows="3">{{ $row->keterangan }}</textarea>
                </div>

                <button class="btn btn-primary">Update</button>
                <a href="{{ route('admin.bahan.index') }}" class="btn btn-secondary">Kembali</a>

            </form>

        </div>
    </div>

</div>
@endsection
