@extends('layouts.admin')

@section('title', 'Dashboard Admin')

@section('content')
<div class="row g-3">
    
    {{-- Stat Cards --}}
    <div class="col-md-3">
        <div class="card shadow-sm rounded-4 p-3 border-0 stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Total Siswa</h6>
                    <h3 class="fw-bold">{{ $totalSiswa ?? 0 }}</h3>
                </div>
                <i class="fa-solid fa-users fa-2x text-primary"></i>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card shadow-sm rounded-4 p-3 border-0 stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Total Guru</h6>
                    <h3 class="fw-bold">{{ $totalGuru ?? 0 }}</h3>
                </div>
                <i class="fa-solid fa-user-tie fa-2x text-success"></i>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card shadow-sm rounded-4 p-3 border-0 stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Inventaris</h6>
                    <h3 class="fw-bold">{{ $totalInventaris ?? 0 }}</h3>
                </div>
                <i class="fa-solid fa-boxes-stacked fa-2x text-warning"></i>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card shadow-sm rounded-4 p-3 border-0 stat-card">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Peminjaman Aktif</h6>
                    <h3 class="fw-bold">{{ $totalPeminjaman ?? 0 }}</h3>
                </div>
                <i class="fa-solid fa-hand-holding fa-2x text-danger"></i>
            </div>
        </div>
    </div>

    {{-- Chart Section --}}
    <div class="col-md-12 mt-4">
        <div class="card rounded-4 shadow-sm border-0 p-4">
            <h5 class="fw-bold mb-3">Grafik Aktivitas (Placeholder)</h5>
            <div style="height: 260px;" class="bg-light rounded-3 d-flex justify-content-center align-items-center text-muted">
                Grafik akan diisi nanti
            </div>
        </div>
    </div>

    {{-- Tabel Aktivitas Terbaru --}}
    <div class="col-md-12 mt-4">
        <div class="card rounded-4 shadow-sm border-0 p-4">
            <h5 class="fw-bold mb-3">Aktivitas Terbaru</h5>

            <table class="table table-hover" id="datatable">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Deskripsi</th>
                        <th>User</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($logs ?? [] as $log)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $log->deskripsi }}</td>
                        <td>{{ $log->user }}</td>
                        <td>{{ $log->created_at }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">Belum ada aktivitas</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>

        </div>
    </div>

</div>
@endsection
