@extends('layouts.admin')
@section('title', 'Edit Siswa')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Edit Siswa</h3>
    <a href="{{ route('admin.siswa.index') }}" class="btn btn-secondary rounded-3 px-4">
        <i class="fa fa-arrow-left me-1"></i> Kembali
    </a>
</div>

<div class="card border-0 shadow-sm rounded-4 p-4">
    <form method="POST" action="{{ route('admin.siswa.update', $row->id) }}">
        @csrf
        @method('PUT')

        <div class="row g-3">

            <div class="col-md-4">
                <label class="form-label">NIS</label>
                <input type="text" name="nis" class="form-control rounded-3" value="{{ $row->nis }}" required>
            </div>

            <div class="col-md-8">
                <label class="form-label">Nama</label>
                <input type="text" name="nama" class="form-control rounded-3" value="{{ $row->nama }}" required>
            </div>

            <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control rounded-3" value="{{ $row->email }}">
            </div>

            <div class="col-md-6">
                <label class="form-label">Password</label>
                <input type="text" name="password" class="form-control rounded-3" placeholder="kosongkan jika tidak diganti">
            </div>

            <div class="col-md-4">
                <label class="form-label">Kelas</label>
                <input type="text" name="kelas" class="form-control rounded-3" value="{{ $row->kelas }}" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">Jurusan</label>
                <input type="text" name="jurusan" class="form-control rounded-3" value="{{ $row->jurusan }}">
            </div>

            <div class="col-md-4">
                <label class="form-label">Telepon</label>
                <input type="text" name="telepon" class="form-control rounded-3" value="{{ $row->telepon }}">
            </div>

        </div>

        <button class="btn btn-primary mt-4 px-4 rounded-3">
            <i class="fa fa-save me-2"></i> Update
        </button>

    </form>
</div>
@endsection
