@extends('layouts.admin')
@section('title', 'Data Siswa')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Data Siswa</h3>
    <a href="{{ route('admin.siswa.create') }}" class="btn btn-primary rounded-3 px-4">
        <i class="fa fa-plus me-2"></i> Tambah Siswa
    </a>
</div>

<div class="card border-0 shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>NIS</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Kelas</th>
                    <th>Jurusan</th>
                    <th>Telepon</th>
                    <th width="130px">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($siswa as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->nis }}</td>
                    <td>{{ $row->nama }}</td>
                    <td>{{ $row->email }}</td>
                    <td>{{ $row->kelas }}</td>
                    <td>{{ $row->jurusan }}</td>
                    <td>{{ $row->telepon }}</td>
                    <td>
                        <a href="{{ route('admin.siswa.edit', $row->id) }}" 
                           class="btn btn-sm btn-warning rounded-3">
                           <i class="fa fa-edit"></i>
                        </a>

                        <form action="{{ route('admin.siswa.delete', $row->id) }}" 
                              method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button onclick="return confirm('Hapus siswa?')" 
                                    class="btn btn-sm btn-danger rounded-3">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
