@extends('layouts.siswa')

@section('title', 'Detail Peminjaman')

@section('content')
<div class="container-fluid">
    <h3 class="mb-4"><i class="fa-solid fa-box"></i> Detail Peminjaman</h3>

    <div class="card p-3 mb-4">
        <p><strong>Kode Peminjaman:</strong> {{ $peminjaman->kode_peminjaman }}</p>
        <p><strong>Tanggal Pinjam:</strong> {{ $peminjaman->tanggal_pinjam }}</p>
        <p><strong>Tanggal Kembali:</strong> {{ $peminjaman->tanggal_kembali }}</p>
        <p><strong>Status:</strong> {{ ucfirst($peminjaman->status) }}</p>
        <p><strong>Total Barang:</strong> {{ $peminjaman->total_barang }}</p>
    </div>

    <div class="card">
        <div class="card-header">
            <i class="fa-solid fa-box"></i> Daftar Barang
        </div>
        <div class="card-body">
            <table class="table table-striped datatable">
                <thead>
                    <tr>
                        <th>Nama Barang</th>
                        <th>Jumlah</th>
                        <th>Kondisi Pinjam</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($peminjaman->detail as $d)
                    <tr>
                        <td>{{ $d->barang->nama_barang }}</td>
                        <td>{{ $d->jumlah }}</td>
                        <td>{{ $d->kondisi_pinjam }}</td>
                        <td>{{ $d->keterangan }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
@endsection