@extends('layouts.siswa')

@section('title', 'Tambah Penggunaan Bahan')

@section('content')
<div class="container-fluid">
    <h3 class="mb-4"><i class="fa-solid fa-plus"></i> Tambah Penggunaan Bahan</h3>

    <div class="card p-3">
        <form action="{{ route('siswa.penggunaan_bahan.store') }}" method="POST">
            @csrf
            <div class="mb-3">
                <label>Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Keterangan</label>
                <textarea name="keterangan" class="form-control" rows="2"></textarea>
            </div>

            <hr>
            <h5>Daftar Bahan</h5>
            <div id="bahan-list">
                <div class="row mb-2 align-items-center bahan-item">
                    <div class="col-md-4">
                        <select name="bahan_id[]" class="form-select" required>
                            <option value="">-- Pilih Bahan --</option>
                            @foreach($bahan as $b)
                            <option value="{{ $b->id }}">{{ $b->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <input type="number" name="jumlah[]" class="form-control" min="1" placeholder="Jumlah" required>
                    </div>
                    <div class="col-md-2">
                        <input type="text" name="satuan[]" class="form-control" placeholder="Satuan" value="pcs">
                    </div>
                    <div class="col-md-3">
                        <input type="text" name="keterangan_detail[]" class="form-control" placeholder="Keterangan">
                    </div>
                    <div class="col-md-1">
                        <button type="button" class="btn btn-danger btn-sm remove-bahan">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>

            <button type="button" class="btn btn-secondary btn-sm mb-3" id="add-bahan">
                <i class="fa-solid fa-plus"></i> Tambah Bahan
            </button>

            <div>
                <button type="submit" class="btn btn-success"><i class="fa-solid fa-save"></i> Simpan Penggunaan</button>
                <a href="{{ route('siswa.penggunaan_bahan.index') }}" class="btn btn-secondary">Batal</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const bahanList = document.getElementById('bahan-list');
    const addBtn = document.getElementById('add-bahan');

    addBtn.addEventListener('click', () => {
        const newItem = bahanList.querySelector('.bahan-item').cloneNode(true);
        newItem.querySelectorAll('input, select').forEach(el => el.value = '');
        bahanList.appendChild(newItem);
    });

    bahanList.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-bahan') || e.target.closest('.remove-bahan')) {
            const item = e.target.closest('.bahan-item');
            if (bahanList.querySelectorAll('.bahan-item').length > 1) {
                item.remove();
            }
        }
    });
});
</script>
@endpush
@endsection