@extends('layouts.siswa')

@section('title', 'Penggunaan Bahan')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="fa-solid fa-flask-vial"></i> Daftar Penggunaan Bahan</h3>
        <a href="{{ route('siswa.penggunaan_bahan.create') }}" class="btn btn-success">
            <i class="fa-solid fa-plus"></i> Tambah Penggunaan
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table table-striped datatable">
                <thead>
                    <tr>
                        <th>Kode</th>
                        <th>Tanggal</th>
                        <th>Keterangan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($penggunaan as $bahan)
                    <tr>
                        <td>{{ $bahan->kode_penggunaan }}</td>
                        <td>{{ $bahan->tanggal }}</td>
                        <td>{{ $bahan->keterangan }}</td>
                        <td>
                            <a href="#" class="btn btn-primary btn-sm">
                                <i class="fa-solid fa-eye"></i> Detail
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
