<?php
use Illuminate\Support\Facades\Route;

// =========================
// LANDING PAGE
// =========================
use App\Http\Controllers\HomeController;
Route::get('/', [HomeController::class, 'index'])->name('home');

// =========================
// SINGLE AUTH CONTROLLER
// =========================
use App\Http\Controllers\AuthController;

// ----------- SINGLE LOGIN FOR ALL USERS -----------
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// ======================================================
// ==================== ADMIN ROUTES ====================
// ======================================================
use App\Http\Controllers\Admin\DashboardController as AdminDashboard;
use App\Http\Controllers\Admin\AdminSiswaController;
use App\Http\Controllers\Admin\AdminGuruController;
use App\Http\Controllers\Admin\AdminInventarisController;
use App\Http\Controllers\Admin\AdminBahanController;
use App\Http\Controllers\Admin\AdminPeminjamanController;
use App\Http\Controllers\Admin\AdminAturanController;
use App\Http\Controllers\Admin\AdminApiSarprasController;

// ----------- ADMIN GROUP -----------
Route::prefix('admin')->group(function () {
    // ----------- DASHBOARD -----------
    Route::get('/dashboard', [AdminDashboard::class, 'index'])->name('admin.dashboard');

    // ----------- CRUD SISWA -----------
    Route::prefix('siswa')->group(function () {
        Route::get('/', [AdminSiswaController::class, 'index'])->name('admin.siswa.index');
        Route::get('/create', [AdminSiswaController::class, 'create'])->name('admin.siswa.create');
        Route::post('/store', [AdminSiswaController::class, 'store'])->name('admin.siswa.store');
        Route::get('/edit/{id}', [AdminSiswaController::class, 'edit'])->name('admin.siswa.edit');
        Route::post('/update/{id}', [AdminSiswaController::class, 'update'])->name('admin.siswa.update');
        Route::delete('/delete/{id}', [AdminSiswaController::class, 'destroy'])->name('admin.siswa.delete');
    });

    // ----------- CRUD GURU -----------
    Route::prefix('guru')->group(function () {
        Route::get('/', [AdminGuruController::class, 'index'])->name('admin.guru.index');
        Route::get('/create', [AdminGuruController::class, 'create'])->name('admin.guru.create');
        Route::post('/store', [AdminGuruController::class, 'store'])->name('admin.guru.store');
        Route::get('/edit/{id}', [AdminGuruController::class, 'edit'])->name('admin.guru.edit');
        Route::post('/update/{id}', [AdminGuruController::class, 'update'])->name('admin.guru.update');
        Route::delete('/delete/{id}', [AdminGuruController::class, 'destroy'])->name('admin.guru.delete');
    });

    // ----------- CRUD INVENTARIS -----------
    Route::prefix('inventaris')->group(function () {
        Route::get('/', [AdminInventarisController::class, 'index'])->name('admin.inventaris.index');
        Route::get('/create', [AdminInventarisController::class, 'create'])->name('admin.inventaris.create');
        Route::post('/store', [AdminInventarisController::class, 'store'])->name('admin.inventaris.store');
        Route::get('/edit/{id}', [AdminInventarisController::class, 'edit'])->name('admin.inventaris.edit');
        Route::post('/update/{id}', [AdminInventarisController::class, 'update'])->name('admin.inventaris.update');
        Route::delete('/delete/{id}', [AdminInventarisController::class, 'destroy'])->name('admin.inventaris.delete');
    });

    // ----------- CRUD BAHAN PRAKTIK -----------
    Route::prefix('bahan')->group(function () {
        Route::get('/', [AdminBahanController::class, 'index'])->name('admin.bahan.index');
        Route::get('/create', [AdminBahanController::class, 'create'])->name('admin.bahan.create');
        Route::post('/store', [AdminBahanController::class, 'store'])->name('admin.bahan.store');
        Route::get('/edit/{id}', [AdminBahanController::class, 'edit'])->name('admin.bahan.edit');
        Route::put('/update/{id}', [AdminBahanController::class, 'update'])->name('admin.bahan.update');
        Route::delete('/delete/{id}', [AdminBahanController::class, 'destroy'])->name('admin.bahan.delete');
    });

    // ----------- PEMINJAMAN -----------
    Route::prefix('peminjaman')->group(function () {
        Route::get('/', [AdminPeminjamanController::class, 'index'])->name('admin.peminjaman.index');
        Route::get('/detail/{id}', [AdminPeminjamanController::class, 'detail'])->name('admin.peminjaman.detail');
        // Tambahan route untuk admin mengelola peminjaman
        Route::post('/approve/{id}', [AdminPeminjamanController::class, 'approve'])->name('admin.peminjaman.approve');
        Route::post('/reject/{id}', [AdminPeminjamanController::class, 'reject'])->name('admin.peminjaman.reject');
        Route::post('/complete/{id}', [AdminPeminjamanController::class, 'complete'])->name('admin.peminjaman.complete');
    });

    // ----------- ATURAN PINJAM -----------
    Route::prefix('aturan')->group(function () {
        Route::get('/', [AdminAturanController::class, 'index'])->name('admin.aturan.index');
        Route::get('/edit/{id}', [AdminAturanController::class, 'edit'])->name('admin.aturan.edit');
        Route::post('/update/{id}', [AdminAturanController::class, 'update'])->name('admin.aturan.update');
    });

    // ----------- API SARPRAS -----------
    Route::prefix('api-sarpras')->group(function () {
        Route::get('/', [AdminApiSarprasController::class, 'index'])->name('admin.api.sarpras.index');
        Route::post('/store', [AdminApiSarprasController::class, 'store'])->name('admin.api.sarpras.store');
        Route::post('/update/{id}', [AdminApiSarprasController::class, 'update'])->name('admin.api.sarpras.update');
        Route::post('/sync', [AdminApiSarprasController::class, 'sync'])->name('admin.api.sarpras.sync');
        Route::get('/logs', [AdminApiSarprasController::class, 'logs'])->name('admin.api.sarpras.logs');
    });

    // ----------- REPORTS -----------
    Route::prefix('laporan')->group(function () {
        Route::get('/peminjaman', [AdminPeminjamanController::class, 'report'])->name('admin.laporan.peminjaman');
        Route::get('/penggunaan-bahan', [AdminBahanController::class, 'report'])->name('admin.laporan.penggunaan_bahan');
    });
});

// ======================================================
// ==================== GURU ROUTES =====================
// ======================================================
use App\Http\Controllers\Guru\DashboardController as GuruDashboard;
use App\Http\Controllers\Guru\GuruInventarisController;
use App\Http\Controllers\Guru\GuruPeminjamanController;
use App\Http\Controllers\Guru\GuruPenggunaanBahanController;
use App\Http\Controllers\Guru\GuruProfilController;

// ----------- GURU GROUP -----------
Route::prefix('guru')->group(function () {
    // DASHBOARD
    Route::get('/dashboard', [GuruDashboard::class, 'index'])->name('guru.dashboard');

    // INVENTARIS GURU
    Route::prefix('inventaris')->group(function () {
        Route::get('/', [GuruInventarisController::class, 'index'])->name('guru.inventaris.index');
        Route::get('/create', [GuruInventarisController::class, 'create'])->name('guru.inventaris.create');
        Route::post('/store', [GuruInventarisController::class, 'store'])->name('guru.inventaris.store');
        Route::get('/edit/{id}', [GuruInventarisController::class, 'edit'])->name('guru.inventaris.edit');
        Route::post('/update/{id}', [GuruInventarisController::class, 'update'])->name('guru.inventaris.update');
        Route::delete('/delete/{id}', [GuruInventarisController::class, 'destroy'])->name('guru.inventaris.delete');
        // SARPRAS SYNC
        Route::post('/sync/{id}', [GuruInventarisController::class, 'syncToSarpras'])->name('guru.inventaris.sync');
    });

    // PEMINJAMAN (APPROVAL)
    Route::prefix('peminjaman')->group(function () {
        Route::get('/', [GuruPeminjamanController::class, 'index'])->name('guru.peminjaman.index');
        Route::get('/detail/{id}', [GuruPeminjamanController::class, 'detail'])->name('guru.peminjaman.detail');
        // Approval routes
        Route::post('/approve/{id}', [GuruPeminjamanController::class, 'approve'])->name('guru.peminjaman.approve');
        Route::post('/reject/{id}', [GuruPeminjamanController::class, 'reject'])->name('guru.peminjaman.reject');
    });

    // PENGGUNAAN BAHAN (PEMBIMBING)
    Route::prefix('penggunaan-bahan')->group(function () {
        Route::get('/', [GuruPenggunaanBahanController::class, 'index'])->name('guru.penggunaan_bahan.index');
        Route::get('/create', [GuruPenggunaanBahanController::class, 'create'])->name('guru.penggunaan_bahan.create');
        Route::post('/store', [GuruPenggunaanBahanController::class, 'store'])->name('guru.penggunaan_bahan.store');
        Route::get('/detail/{id}', [GuruPenggunaanBahanController::class, 'detail'])->name('guru.penggunaan_bahan.detail');
        Route::post('/approve/{id}', [GuruPenggunaanBahanController::class, 'approve'])->name('guru.penggunaan_bahan.approve');
    });

    // PROFIL
    Route::get('/profil', [GuruProfilController::class, 'index'])->name('guru.profil');
    Route::post('/profil/update', [GuruProfilController::class, 'update'])->name('guru.profil.update');
    
    // SARPRAS AGREEMENT
    Route::post('/sarpras/setuju', [GuruProfilController::class, 'setujuSarpras'])->name('guru.sarpras.setuju');
});

// ======================================================
// ==================== SISWA ROUTES ====================
// ======================================================
use App\Http\Controllers\Siswa\DashboardController as SiswaDashboard;
use App\Http\Controllers\Siswa\SiswaPeminjamanController;
use App\Http\Controllers\Siswa\SiswaPenggunaanBahanController;
use App\Http\Controllers\Siswa\SiswaProfilController;

// ----------- SISWA GROUP -----------
Route::prefix('siswa')->group(function () {
    // DASHBOARD
    Route::get('/dashboard', [SiswaDashboard::class, 'index'])->name('siswa.dashboard');

    // PEMINJAMAN ALAT
    Route::prefix('peminjaman')->group(function () {
        Route::get('/', [SiswaPeminjamanController::class, 'index'])->name('siswa.peminjaman.index');
        Route::get('/create', [SiswaPeminjamanController::class, 'create'])->name('siswa.peminjaman.create');
        Route::post('/store', [SiswaPeminjamanController::class, 'store'])->name('siswa.peminjaman.store');
        Route::get('/detail/{id}', [SiswaPeminjamanController::class, 'detail'])->name('siswa.peminjaman.detail');
        Route::post('/cancel/{id}', [SiswaPeminjamanController::class, 'cancel'])->name('siswa.peminjaman.cancel');
        Route::get('/history', [SiswaPeminjamanController::class, 'history'])->name('siswa.peminjaman.history');
    });

    // PENGGUNAAN BAHAN
    Route::prefix('penggunaan-bahan')->group(function () {
        Route::get('/', [SiswaPenggunaanBahanController::class, 'index'])->name('siswa.penggunaan_bahan.index');
        Route::get('/create', [SiswaPenggunaanBahanController::class, 'create'])->name('siswa.penggunaan_bahan.create');
        Route::post('/store', [SiswaPenggunaanBahanController::class, 'store'])->name('siswa.penggunaan_bahan.store');
        Route::get('/detail/{id}', [SiswaPenggunaanBahanController::class, 'detail'])->name('siswa.penggunaan_bahan.detail');
        Route::get('/history', [SiswaPenggunaanBahanController::class, 'history'])->name('siswa.penggunaan_bahan.history');
    });

    // PROFIL
    Route::get('/profil', [SiswaProfilController::class, 'index'])->name('siswa.profil');
    Route::post('/profil/update', [SiswaProfilController::class, 'update'])->name('siswa.profil.update');
});

// ======================================================
// ==================== PUBLIC ROUTES ===================
// ======================================================

// ABOUT PAGE
Route::get('/tentang', [HomeController::class, 'about'])->name('about');

// CONTACT PAGE
Route::get('/kontak', [HomeController::class, 'contact'])->name('contact');

// GUIDE/HELP PAGE
Route::get('/panduan', [HomeController::class, 'guide'])->name('guide');

// ======================================================
// ==================== API ROUTES ======================
// ======================================================

// Load api routes
require __DIR__.'/api.php';