

<?php $__env->startSection('title', 'Daftar Peminjaman Alat'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <h3 class="mb-4">Daftar Peminjaman Alat</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-striped table-bordered" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Kode Peminjaman</th>
                        <th>Peminjam</th>
                        <th>Status</th>
                        <th>Tanggal Pinjam</th>
                        <th>Tanggal Kembali</th>
                        <th>Total Barang</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $peminjaman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($pm->kode_peminjaman); ?></td>
                        <td>
                            <?php if($pm->peminjam_role === 'siswa'): ?>
                                <?php echo e($pm->siswa?->nama ?? '-'); ?>

                            <?php else: ?>
                                <?php echo e($pm->guru?->nama ?? '-'); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge 
                                <?php echo e($pm->status == 'dipinjam' ? 'bg-warning' : ($pm->status == 'dikembalikan' ? 'bg-success' : 'bg-secondary')); ?>">
                                <?php echo e(ucfirst($pm->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($pm->tanggal_pinjam); ?></td>
                        <td><?php echo e($pm->tanggal_kembali); ?></td>
                        <td><?php echo e($pm->total_barang); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.peminjaman.detail', $pm->id)); ?>" class="btn btn-sm btn-primary">
                                <i class="fa fa-eye"></i> Detail
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/peminjaman/index.blade.php ENDPATH**/ ?>