

<?php $__env->startSection('title', 'Tambah Penggunaan Bahan'); ?>

<?php $__env->startSection('content'); ?>
<div class="card shadow-sm border-0">
    <div class="card-body">
        <h3 class="mb-4"><i class="fa-solid fa-flask-vial"></i> Tambah Penggunaan Bahan</h3>

        <form action="<?php echo e(route('guru.penggunaan_bahan.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="kode_penggunaan" class="form-label">Kode Penggunaan</label>
                    <input type="text" name="kode_penggunaan" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label for="id_siswa" class="form-label">Siswa</label>
                    <input type="number" name="id_siswa" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="tanggal" class="form-label">Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label for="keterangan" class="form-label">Keterangan</label>
                    <input type="text" name="keterangan" class="form-control">
                </div>
            </div>

            <h5 class="mt-4">Bahan</h5>
            <div id="bahanContainer">
                <div class="row mb-2 align-items-center">
                    <div class="col-md-4">
                        <label class="form-label">Bahan</label>
                        <select name="bahan[0][id_bahan]" class="form-select" required>
                            <option value="">-- Pilih Bahan --</option>
                            <?php $__currentLoopData = $bahan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->nama); ?> (<?php echo e($item->stok); ?> <?php echo e($item->satuan); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Jumlah</label>
                        <input type="number" name="bahan[0][jumlah]" class="form-control" value="1" min="1" required>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Satuan</label>
                        <input type="text" name="bahan[0][satuan]" class="form-control" placeholder="pcs" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Keterangan</label>
                        <input type="text" name="bahan[0][keterangan]" class="form-control" placeholder="Opsional">
                    </div>
                    <div class="col-md-1 d-flex align-items-end">
                        <button type="button" class="btn btn-danger removeBahan"><i class="fa-solid fa-trash"></i></button>
                    </div>
                </div>
            </div>

            <button type="button" class="btn btn-secondary mb-3" id="addBahan"><i class="fa-solid fa-plus"></i> Tambah Bahan</button>
            <br>
            <button type="submit" class="btn btn-success"><i class="fa-solid fa-save"></i> Simpan</button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let bahanIndex = 1;

// Tambah Bahan
$('#addBahan').click(function() {
    let html = `<div class="row mb-2 align-items-center">
        <div class="col-md-4">
            <select name="bahan[${bahanIndex}][id_bahan]" class="form-select" required>
                <option value="">-- Pilih Bahan --</option>
                <?php $__currentLoopData = $bahan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->nama); ?> (<?php echo e($item->stok); ?> <?php echo e($item->satuan); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-2">
            <input type="number" name="bahan[${bahanIndex}][jumlah]" class="form-control" value="1" min="1" required>
        </div>
        <div class="col-md-2">
            <input type="text" name="bahan[${bahanIndex}][satuan]" class="form-control" placeholder="pcs" required>
        </div>
        <div class="col-md-3">
            <input type="text" name="bahan[${bahanIndex}][keterangan]" class="form-control" placeholder="Opsional">
        </div>
        <div class="col-md-1 d-flex align-items-end">
            <button type="button" class="btn btn-danger removeBahan"><i class="fa-solid fa-trash"></i></button>
        </div>
    </div>`;
    $('#bahanContainer').append(html);
    bahanIndex++;
});

// Hapus Bahan
$(document).on('click', '.removeBahan', function() {
    $(this).closest('.row').remove();
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.guru', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/guru/penggunaan_bahan/create.blade.php ENDPATH**/ ?>