
<?php $__env->startSection('title', 'Data Siswa'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Data Siswa</h3>
    <a href="<?php echo e(route('admin.siswa.create')); ?>" class="btn btn-primary rounded-3 px-4">
        <i class="fa fa-plus me-2"></i> Tambah Siswa
    </a>
</div>

<div class="card border-0 shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>NIS</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Kelas</th>
                    <th>Jurusan</th>
                    <th>Telepon</th>
                    <th width="130px">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($row->nis); ?></td>
                    <td><?php echo e($row->nama); ?></td>
                    <td><?php echo e($row->email); ?></td>
                    <td><?php echo e($row->kelas); ?></td>
                    <td><?php echo e($row->jurusan); ?></td>
                    <td><?php echo e($row->telepon); ?></td>
                    <td>
                        <a href="<?php echo e(route('admin.siswa.edit', $row->id)); ?>" 
                           class="btn btn-sm btn-warning rounded-3">
                           <i class="fa fa-edit"></i>
                        </a>

                        <form action="<?php echo e(route('admin.siswa.delete', $row->id)); ?>" 
                              method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button onclick="return confirm('Hapus siswa?')" 
                                    class="btn btn-sm btn-danger rounded-3">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/siswa/index.blade.php ENDPATH**/ ?>