

<?php $__env->startSection('content'); ?>
<div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold">Daftar Bahan Praktik</h4>
        <a href="<?php echo e(route('admin.bahan.create')); ?>" class="btn btn-primary btn-sm">
            + Tambah Bahan
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-bordered table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th width="50">#</th>
                        <th>Kode</th>
                        <th>Nama</th>
                        <th>Stok</th>
                        <th>Satuan</th>
                        <th>Keterangan</th>
                        <th width="120">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $bahan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i+1); ?></td>
                        <td><?php echo e($b->kode); ?></td>
                        <td><?php echo e($b->nama); ?></td>
                        <td><?php echo e($b->stok); ?></td>
                        <td><?php echo e($b->satuan); ?></td>
                        <td><?php echo e($b->keterangan ?? '-'); ?></td>
                        <td>
                            <form action="<?php echo e(route('admin.bahan.delete', $b->id)); ?>" method="POST"
                                  onsubmit="return confirm('Hapus bahan ini?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>

                                <button class="btn btn-danger btn-sm">Hapus</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($bahan->count() == 0): ?>
                    <tr>
                        <td colspan="7" class="text-center py-3 text-muted">
                            Tidak ada data bahan praktik.
                        </td>
                    </tr>
                    <?php endif; ?>

                </tbody>
            </table>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/bahan/index.blade.php ENDPATH**/ ?>