

<?php $__env->startSection('title', 'Data Inventaris'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold">Data Inventaris</h4>
    <a href="<?php echo e(route('admin.inventaris.create')); ?>" class="btn btn-primary">
        <i class="fa fa-plus me-1"></i> Tambah Inventaris
    </a>
</div>

<div class="card shadow-sm">
    <div class="card-body">

        <table id="datatable" class="table table-striped table-bordered align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Kode</th>
                    <th>Nama Barang</th>
                    <th>Kategori</th>
                    <th>Jumlah</th>
                    <th>Kondisi</th>
                    <th>Lokasi</th>
                    <th width="130">Aksi</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $inventaris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($i->kode_barang); ?></td>
                    <td><?php echo e($i->nama_barang); ?></td>
                    <td><?php echo e($i->kategori->nama ?? '-'); ?></td>
                    <td><?php echo e($i->jumlah); ?></td>
                    <td><?php echo e($i->kondisi); ?></td>
                    <td><?php echo e($i->lokasi); ?></td>

                    <td>
                        <a href="<?php echo e(route('admin.inventaris.edit', $i->id)); ?>" class="btn btn-warning btn-sm">
                            <i class="fa fa-edit"></i>
                        </a>

                        <form action="<?php echo e(route('admin.inventaris.delete', $i->id)); ?>"
                              method="POST"
                              class="d-inline"
                              onsubmit="return confirm('Hapus data ini?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>

                            <button class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/inventaris/index.blade.php ENDPATH**/ ?>