<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $__env->yieldContent('title','Admin Panel'); ?> — Inventaris TKJT</title>

  <!-- Bootstrap 5 & Font Awesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  
  <?php echo $__env->yieldPushContent('head'); ?>

  <style>
    body {
      background: #f6f8fb;
      font-family: system-ui, -apple-system, sans-serif;
    }
    .sidebar {
      width: 250px;
      background: white;
      min-height: 100vh;
      box-shadow: 2px 0 10px rgba(0,0,0,0.05);
    }
    .sidebar .nav-link {
      padding: 12px 16px;
      margin: 2px 10px;
      border-radius: 8px;
      color: #475569;
    }
    .sidebar .nav-link:hover, .sidebar .nav-link.active {
      background: #e0f2fe;
      color: #0369a1;
    }
    .content {
      flex: 1;
      padding: 20px;
    }
    .navbar {
      background: white;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    }
    .card {
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.05);
      border: none;
    }
  </style>
</head>
<body>
<div class="d-flex">
  <!-- Sidebar -->
  <div class="sidebar d-none d-lg-block">
    <div class="p-3 border-bottom">
      <h5 class="mb-0"><i class="fa-solid fa-warehouse text-primary"></i> Admin Panel</h5>
      <small class="text-muted">Sistem Inventaris TKJT</small>
    </div>
    
    <div class="p-3">
      <div class="small text-uppercase text-muted mb-2">Navigasi</div>
      <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
        <i class="fa-solid fa-gauge-high"></i> Dashboard
      </a>
      
      <div class="small text-uppercase text-muted mb-2 mt-3">Manajemen</div>
      <a class="nav-link <?php echo e(request()->is('admin/siswa*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.siswa.index')); ?>">
        <i class="fa-solid fa-user-graduate"></i> Siswa
      </a>
      <a class="nav-link <?php echo e(request()->is('admin/guru*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.guru.index')); ?>">
        <i class="fa-solid fa-chalkboard-user"></i> Guru
      </a>
      <a class="nav-link <?php echo e(request()->is('admin/inventaris*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.inventaris.index')); ?>">
        <i class="fa-solid fa-boxes-packing"></i> Inventaris
      </a>
      <a class="nav-link <?php echo e(request()->is('admin/bahan*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.bahan.index')); ?>">
        <i class="fa-solid fa-flask-vial"></i> Bahan Praktik
      </a>
      <a class="nav-link <?php echo e(request()->is('admin/peminjaman*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.peminjaman.index')); ?>">
        <i class="fa-solid fa-hand-holding"></i> Peminjaman
      </a>
      
      <div class="small text-uppercase text-muted mb-2 mt-3">Sistem</div>
      <a class="nav-link <?php echo e(request()->is('admin/aturan*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.aturan.index')); ?>">
        <i class="fa-solid fa-gavel"></i> Aturan
      </a>
      <a class="nav-link <?php echo e(request()->is('admin/api-sarpras*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.api.sarpras.index')); ?>">
        <i class="fa-solid fa-network-wired"></i> API Sarpras
      </a>
    </div>
  </div>

  <!-- Main Content -->
  <div class="flex-grow-1 d-flex flex-column">
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
      <div class="container-fluid">
        <button class="btn d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarMobile">
          <i class="fa-solid fa-bars"></i>
        </button>
        <span class="navbar-brand"><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?></span>
        <div>
          <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
            <?php echo csrf_field(); ?>
            <button class="btn btn-outline-danger btn-sm">
              <i class="fa-solid fa-right-from-bracket"></i> Logout
            </button>
          </form>
        </div>
      </div>
    </nav>

    <!-- Content -->
    <main class="content">
      <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
          <?php echo e(session('success')); ?>

          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      <?php endif; ?>
      <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
          <?php echo e(session('error')); ?>

          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      <?php endif; ?>
      
      <?php echo $__env->yieldContent('content'); ?>
    </main>
  </div>
</div>

<!-- Mobile Sidebar -->
<div class="offcanvas offcanvas-start d-lg-none" id="sidebarMobile">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title">Menu Admin</h5>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div class="d-grid gap-2">
      <a class="btn btn-outline-primary text-start" href="<?php echo e(route('admin.dashboard')); ?>">
        <i class="fa-solid fa-gauge-high"></i> Dashboard
      </a>
      <a class="btn btn-outline-primary text-start" href="<?php echo e(route('admin.siswa.index')); ?>">
        <i class="fa-solid fa-user-graduate"></i> Siswa
      </a>
      <a class="btn btn-outline-primary text-start" href="<?php echo e(route('admin.guru.index')); ?>">
        <i class="fa-solid fa-chalkboard-user"></i> Guru
      </a>
      <a class="btn btn-outline-primary text-start" href="<?php echo e(route('admin.inventaris.index')); ?>">
        <i class="fa-solid fa-boxes-packing"></i> Inventaris
      </a>
      <a class="btn btn-outline-primary text-start" href="<?php echo e(route('admin.peminjaman.index')); ?>">
        <i class="fa-solid fa-hand-holding"></i> Peminjaman
      </a>
      <form method="POST" action="<?php echo e(route('logout')); ?>" class="mt-3">
        <?php echo csrf_field(); ?>
        <button class="btn btn-danger w-100">
          <i class="fa-solid fa-right-from-bracket"></i> Logout
        </button>
      </form>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Auto-dismiss alerts after 5 seconds
  setTimeout(() => {
    document.querySelectorAll('.alert').forEach(alert => {
      alert.classList.remove('show');
    });
  }, 5000);
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/layouts/admin.blade.php ENDPATH**/ ?>