

<?php $__env->startSection('title', 'Inventaris'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Daftar Inventaris</h3>
    <a href="<?php echo e(route('guru.inventaris.create')); ?>" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Tambah Inventaris</a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<table id="inventarisTable" class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Kode</th>
            <th>Nama Barang</th>
            <th>Jumlah</th>
            <th>Kondisi</th>
            <th>Lokasi</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $inventaris; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($item->kode_barang); ?></td>
            <td><?php echo e($item->nama_barang); ?></td>
            <td><?php echo e($item->jumlah); ?></td>
            <td><?php echo e($item->kondisi); ?></td>
            <td><?php echo e($item->lokasi); ?></td>
            <td><?php echo e($item->keterangan); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#inventarisTable').DataTable();
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.guru', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/guru/inventaris/index.blade.php ENDPATH**/ ?>