<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PeminjamanAlat;

class AdminPeminjamanController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');

        $peminjaman = PeminjamanAlat::with(['siswa','guru'])
            ->orderBy('id','desc')
            ->get();

        return view('admin.peminjaman.index', compact('peminjaman'));
    }

    public function detail($id)
    {
        if (!session('admin_id')) return redirect()->route('login');

        $pm = PeminjamanAlat::with(['siswa','guru','detail.barang'])
            ->findOrFail($id);

        $details = $pm->detail;

        return view('admin.peminjaman.detail', compact('pm','details'));
    }

    public function verify($id)
    {
        if (!session('admin_id')) return redirect()->route('login');

        PeminjamanAlat::findOrFail($id)->update([
            'status' => 'dipinjam',
            'id_admin_verifikasi' => session('admin_id')
        ]);

        return back()->with('success','Peminjaman diverifikasi');
    }

    public function complete($id)
    {
        if (!session('admin_id')) return redirect()->route('login');

        PeminjamanAlat::findOrFail($id)->update([
            'status' => 'dikembalikan'
        ]);

        return back()->with('success','Peminjaman selesai');
    }
}
