<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Guru;
use App\Models\Siswa;

class AuthController extends Controller
{
    public function showLoginForm()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');

        // ✅ AUTO-DETECT: Cari di semua tabel
        $admin = Admin::where('email', $email)->where('password', $password)->first();
        $guru = Guru::where('email', $email)->where('password', $password)->first();
        $siswa = Siswa::where('email', $email)->where('password', $password)->first();

        if ($admin) {
            session(['admin_id' => $admin->id, 'user_role' => 'admin', 'user_name' => $admin->nama]);
            return redirect()->route('admin.dashboard');
        }
        
        if ($guru) {
            session(['guru_id' => $guru->id, 'user_role' => 'guru', 'user_name' => $guru->nama]);
            return redirect()->route('guru.dashboard');
        }
        
        if ($siswa) {
            session(['siswa_id' => $siswa->id, 'user_role' => 'siswa', 'user_name' => $siswa->nama]);
            return redirect()->route('siswa.dashboard');
        }

        return redirect()->route('login')->with('error', 'Email atau password salah.');
    }

    public function logout()
    {
        $role = session('user_role');
        
        if ($role === 'admin') session()->forget('admin_id');
        elseif ($role === 'guru') session()->forget('guru_id');
        elseif ($role === 'siswa') session()->forget('siswa_id');
        
        session()->forget(['user_role', 'user_name']);
        return redirect()->route('home');
    }
}