<?php
namespace App\Http\Controllers\Guru;
use App\Http\Controllers\Controller;
use App\Models\InventarisGuru;
use App\Models\PeminjamanAlat;
use App\Models\PenggunaanBahan;

class DashboardController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('guru_id')) return redirect()->route('login');
        
        $guru_id = session('guru_id');
        
        // ✅ PERBAIKI: Filter by guru_id
        $totalInventaris = InventarisGuru::where('id_guru', $guru_id)->count();
        $totalPeminjaman = PeminjamanAlat::where('id_guru_persetujuan', $guru_id)->count();
        $totalPenggunaanBahan = PenggunaanBahan::where('id_guru', $guru_id)->count();

        return view('guru.dashboard', compact(
            'totalInventaris',
            'totalPeminjaman',
            'totalPenggunaanBahan'
        ));
    }
}