<?php
namespace App\Http\Controllers\Guru;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PenggunaanBahan;
use App\Models\PenggunaanBahanDetail;
use App\Models\BahanPraktik;
use App\Models\Siswa;

class GuruPenggunaanBahanController extends Controller
{
    public function index()
    {
        if (!session('guru_id')) return redirect()->route('login');

        $penggunaan = PenggunaanBahan::with('siswa')
            ->where('id_guru', session('guru_id'))
            ->orderBy('id','desc')
            ->get();

        return view('guru.penggunaan_bahan.index', compact('penggunaan'));
    }

    public function create()
    {
        if (!session('guru_id')) return redirect()->route('login');

        $bahan = BahanPraktik::orderBy('nama')->get();
        $siswa = Siswa::orderBy('nama')->get();

        return view('guru.penggunaan_bahan.create', compact('bahan','siswa'));
    }

    public function store(Request $request)
    {
        if (!session('guru_id')) return redirect()->route('login');

        // VALIDASI STOK
        foreach ($request->bahan as $b) {
            $stok = BahanPraktik::find($b['id_bahan']);
            if (!$stok || $stok->stok < $b['jumlah']) {
                return back()->with('error','Stok bahan tidak mencukupi');
            }
        }

        // SIMPAN HEADER
        $penggunaan = PenggunaanBahan::create([
            'kode_penggunaan' => 'PB-' . date('YmdHis'),
            'id_siswa' => $request->id_siswa,
            'id_guru' => session('guru_id'),
            'tanggal' => $request->tanggal,
            'keterangan' => $request->keterangan
        ]);

        // SIMPAN DETAIL + KURANGI STOK
        foreach ($request->bahan as $b) {
            PenggunaanBahanDetail::create([
                'penggunaan_id' => $penggunaan->id,
                'id_bahan' => $b['id_bahan'],
                'jumlah' => $b['jumlah'],
                'satuan' => $b['satuan'],
                'keterangan' => $b['keterangan'] ?? null
            ]);

            $stok = BahanPraktik::find($b['id_bahan']);
            $stok->stok -= $b['jumlah'];
            $stok->save();
        }

        return redirect()
            ->route('guru.penggunaan_bahan.index')
            ->with('success','Penggunaan bahan berhasil disimpan');
    }

    public function detail($id)
    {
        if (!session('guru_id')) return redirect()->route('login');

        $penggunaan = PenggunaanBahan::with(['detail.bahan','siswa'])
            ->where('id_guru', session('guru_id'))
            ->findOrFail($id);

        return view('guru.penggunaan_bahan.detail', compact('penggunaan'));
    }
}
