<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function index()
    {
        // Ambil data inventaris terbaru (limit 6)
        $inventaris = DB::select("SELECT i.*, k.nama as kategori 
                                  FROM inventaris i
                                  LEFT JOIN kategori_inventaris k ON i.id_kategori = k.id
                                  ORDER BY i.created_at DESC
                                  LIMIT 6");

        // Ambil kategori inventaris
        $kategori = DB::select("SELECT * FROM kategori_inventaris ORDER BY nama ASC");

        // Ambil statistik
        $statistik = [
            'total_siswa' => DB::table('siswa')->count(),
            'total_guru' => DB::table('guru')->count(),
            'total_inventaris' => DB::table('inventaris')->count(),
            'total_bahan' => DB::table('bahan_praktik')->count(),
        ];

        return view('home', compact('inventaris', 'kategori', 'statistik'));
    }
}
