<?php

namespace App\Http\Controllers\Siswa;

use App\Http\Controllers\Controller;
use App\Models\PeminjamanAlat;
use App\Models\PenggunaanBahan;

class DashboardController extends Controller
{
    public function index()
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login')->with('error', 'Silakan login terlebih dahulu.');
        }
        
        $siswa_id = session('siswa_id');
        
        // ✅ PERBAIKI: Hanya ambil data siswa yang login
        $peminjaman = PeminjamanAlat::where('peminjam_id', $siswa_id)
            ->where('peminjam_role', 'siswa')
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        // ✅ PERBAIKI: Hanya ambil data siswa yang login
        $penggunaanBahan = PenggunaanBahan::where('id_siswa', $siswa_id)
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();
            
        // ✅ TAMBAHKAN: Statistics
        $stats = [
            'total_peminjaman' => PeminjamanAlat::where('peminjam_id', $siswa_id)
                ->where('peminjam_role', 'siswa')->count(),
            'peminjaman_pending' => PeminjamanAlat::where('peminjam_id', $siswa_id)
                ->where('peminjam_role', 'siswa')
                ->where('status', 'pending')->count(),
            'peminjaman_disetujui' => PeminjamanAlat::where('peminjam_id', $siswa_id)
                ->where('peminjam_role', 'siswa')
                ->where('status', 'disetujui')->count(),
            'total_penggunaan' => PenggunaanBahan::where('id_siswa', $siswa_id)->count(),
        ];

        return view('siswa.dashboard', compact('peminjaman', 'penggunaanBahan', 'stats'));
    }
}