<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Inventaris extends Model
{
    protected $table = 'inventaris';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'kode_barang','nama_barang','id_kategori',
        'jumlah','kondisi','lokasi','keterangan'
    ];

    public function kategori()
    {
        return $this->belongsTo(KategoriInventaris::class, 'id_kategori');
    }

    public function barang()
    {
        return $this->hasMany(Barang::class, 'id_inventaris');
    }
}
