<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PeminjamanDetail extends Model
{
    protected $table = 'peminjaman_detail';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'peminjaman_id','id_barang','jumlah',
        'kondisi_pinjam','kondisi_kembali','keterangan'
    ];

    public function peminjaman()
    {
        return $this->belongsTo(PeminjamanAlat::class, 'peminjaman_id');
    }

    public function barang()
    {
        return $this->belongsTo(Barang::class, 'id_barang');
    }
}
