@extends('layouts.admin')
@section('title', 'Koneksi API Sarpras')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Koneksi API Sarpras</h3>
    <form action="{{ route('admin.api.sarpras.sync') }}" method="POST">
        @csrf
        <button class="btn btn-success rounded-3 px-4">
            <i class="fa fa-sync me-2"></i> Sync Sekarang
        </button>
    </form>
</div>

<div class="card shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table table-striped table-bordered align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Nama Aplikasi</th>
                    <th>Endpoint URL</th>
                    <th>Status</th>
                    <th>Last Sync</th>
                </tr>
            </thead>
            <tbody>
                @foreach($koneksi as $k)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $k->nama_aplikasi }}</td>
                    <td>{{ $k->endpoint_url }}</td>
                    <td>
                        <span class="badge {{ $k->aktif ? 'bg-success' : 'bg-secondary' }}">
                            {{ $k->aktif ? 'Aktif' : 'Nonaktif' }}
                        </span>
                    </td>
                    <td>{{ $k->last_sync ? $k->last_sync->format('d-m-Y H:i') : '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function(){
    $('#datatable').DataTable({"order":[[0,"desc"]]});
});
</script>
@endpush
@endsection
