@extends('layouts.admin')

@section('title', 'Edit Aturan Peminjaman')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Edit Aturan Peminjaman</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.aturan.update', $row->id) }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="nama" class="form-label">Nama Aturan</label>
                    <input type="text" name="nama" id="nama" class="form-control" value="{{ $row->nama }}" required>
                </div>

                <div class="mb-3">
                    <label for="deskripsi" class="form-label">Deskripsi</label>
                    <textarea name="deskripsi" id="deskripsi" class="form-control" rows="3">{{ $row->deskripsi }}</textarea>
                </div>

                <div class="mb-3">
                    <label for="maksimal_hari" class="form-label">Maksimal Hari</label>
                    <input type="number" name="maksimal_hari" id="maksimal_hari" class="form-control" value="{{ $row->maksimal_hari }}" required>
                </div>

                <div class="mb-3">
                    <label for="denda_per_hari" class="form-label">Denda per Hari</label>
                    <input type="text" name="denda_per_hari" id="denda_per_hari" class="form-control" value="{{ $row->denda_per_hari }}">
                </div>

                <div class="form-check mb-3">
                    <input type="checkbox" name="perlu_persetujuan_guru" id="perlu_persetujuan_guru" class="form-check-input" {{ $row->perlu_persetujuan_guru ? 'checked' : '' }}>
                    <label for="perlu_persetujuan_guru" class="form-check-label">Perlu Persetujuan Guru</label>
                </div>

                <div class="form-check mb-3">
                    <input type="checkbox" name="aktif" id="aktif" class="form-check-input" {{ $row->aktif ? 'checked' : '' }}>
                    <label for="aktif" class="form-check-label">Aktif</label>
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Update
                </button>
                <a href="{{ route('admin.aturan.index') }}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> Kembali
                </a>
            </form>
        </div>
    </div>
</div>
@endsection
