@extends('layouts.admin')

@section('title', 'Tambah Guru')

@section('content')
<h4 class="fw-bold mb-3">Tambah Guru</h4>

<div class="card shadow-sm">
    <div class="card-body">

        <form action="{{ route('admin.guru.store') }}" method="POST">
            @csrf

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>NIP</label>
                    <input type="text" name="nip" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Nama</label>
                    <input type="text" name="nama" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Password (plaintext)</label>
                    <input type="text" name="password" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Telepon</label>
                    <input type="text" name="telepon" class="form-control">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Jabatan</label>
                    <input type="text" name="jabatan" class="form-control" value="Guru">
                </div>

                <div class="col-md-6 mb-3">
                    <label class="d-block">Harus Setujui Sarpras?</label>
                    <input type="checkbox" name="harus_setujui_sarpras" value="1"> Ya
                </div>
            </div>

            <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Simpan</button>
            <a href="{{ route('admin.guru.index') }}" class="btn btn-secondary">Kembali</a>

        </form>

    </div>
</div>
@endsection
