<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Inventaris TKJT</title>

    <!-- Bootstrap 5 & Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

    <style>
        body {
            background: linear-gradient(135deg, #4a90e2, #50e3c2);
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .login-card {
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            padding: 40px 30px;
            width: 100%;
            max-width: 400px;
        }
        .login-card h3 {
            font-weight: 600;
            margin-bottom: 25px;
            text-align: center;
            color: #4a90e2;
        }
        .form-control {
            border-radius: 12px;
            padding: 10px 15px;
            border: 1px solid #ddd;
        }
        .btn-login {
            border-radius: 12px;
            background: #4a90e2;
            color: #fff;
            font-weight: 600;
            padding: 12px;
            width: 100%;
            border: none;
            transition: 0.3s;
        }
        .btn-login:hover {
            background: #3b78c1;
            transform: translateY(-2px);
        }
        .login-footer {
            text-align: center;
            margin-top: 15px;
            font-size: 14px;
            color: #6c757d;
        }
        .login-footer a {
            color: #4a90e2;
            text-decoration: none;
        }
        .login-footer a:hover {
            text-decoration: underline;
        }
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <h3>
            <i class="fa-solid fa-right-to-bracket"></i>
            Login Sistem
        </h3>
        
        <p class="text-center text-muted mb-4">
            Masukkan email dan password Anda
        </p>

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <form action="{{ route('login.submit') }}" method="POST">
            @csrf
            
            <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" name="email" id="email" class="form-control" 
                       placeholder="admin@guru.siswa@example.com" required>
            </div>

            <div class="mb-4 position-relative">
                <label for="password" class="form-label">Password</label>
                <input type="password" name="password" id="password" class="form-control" 
                       placeholder="Masukkan password" required>
               
            </div>

            <button type="submit" class="btn btn-login mb-3">
                <i class="fa-solid fa-right-to-bracket"></i> Login Sekarang
            </button>
        </form>

        <div class="login-footer">
            <a href="{{ route('home') }}">
                <i class="fa-solid fa-arrow-left"></i> Kembali ke Beranda
            </a>
            <span class="mx-2">•</span>
            <small>© {{ date('Y') }} Inventaris TKJT</small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle password visibility
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const icon = this.querySelector('i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
        
        // Auto focus email field
        document.getElementById('email').focus();
        
        // Auto-dismiss alerts
        setTimeout(() => {
            document.querySelectorAll('.alert').forEach(alert => {
                alert.classList.remove('show');
            });
        }, 5000);
    </script>
</body>
</html>