@extends('layouts.guru')

@section('title', 'Inventaris')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Daftar Inventaris</h3>
    <a href="{{ route('guru.inventaris.create') }}" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Tambah Inventaris</a>
</div>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table id="inventarisTable" class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Kode</th>
            <th>Nama Barang</th>
            <th>Jumlah</th>
            <th>Kondisi</th>
            <th>Lokasi</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        @foreach($inventaris as $item)
        <tr>
            <td>{{ $item->kode_barang }}</td>
            <td>{{ $item->nama_barang }}</td>
            <td>{{ $item->jumlah }}</td>
            <td>{{ $item->kondisi }}</td>
            <td>{{ $item->lokasi }}</td>
            <td>{{ $item->keterangan }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#inventarisTable').DataTable();
});
</script>
@endpush
