@extends('layouts.guru')

@section('title', 'Detail Peminjaman')

@section('content')
<div class="mb-3">
    <h4 class="mb-1">
        <i class="fa-solid fa-file-lines me-2"></i>
        Detail Peminjaman
    </h4>
    <small class="text-muted">{{ $peminjaman->kode_peminjaman }}</small>
</div>

{{-- INFO UTAMA --}}
<div class="card shadow-sm mb-3">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-6">
                <div class="small text-muted">Tanggal Pinjam</div>
                <div class="fw-semibold">{{ $peminjaman->tanggal_pinjam }}</div>
            </div>

            <div class="col-md-6">
                <div class="small text-muted">Tanggal Kembali</div>
                <div class="fw-semibold">{{ $peminjaman->tanggal_kembali ?? '-' }}</div>
            </div>

            <div class="col-md-6">
                <div class="small text-muted">Status</div>
                <span class="badge fs-6
                    @if($peminjaman->status == 'pending') bg-warning
                    @elseif($peminjaman->status == 'disetujui') bg-success
                    @elseif($peminjaman->status == 'ditolak') bg-danger
                    @elseif($peminjaman->status == 'dipinjam') bg-primary
                    @elseif($peminjaman->status == 'dikembalikan') bg-secondary
                    @else bg-dark
                    @endif">
                    {{ strtoupper($peminjaman->status) }}
                </span>
            </div>

            <div class="col-md-6">
                <div class="small text-muted">Total Barang</div>
                <div class="fw-semibold">{{ $peminjaman->total_barang }}</div>
            </div>
        </div>
    </div>
</div>

{{-- DETAIL BARANG --}}
<div class="card shadow-sm mb-3">
    <div class="card-body">
        <h6 class="mb-3">
            <i class="fa-solid fa-list me-2"></i>Barang Dipinjam
        </h6>

        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Barang</th>
                        <th class="text-center">Jumlah</th>
                        <th>Kondisi Pinjam</th>
                        <th>Kondisi Kembali</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($peminjaman->detail as $d)
                    <tr>
                        <td class="fw-semibold">{{ $d->barang->nama }}</td>
                        <td class="text-center">{{ $d->jumlah }}</td>
                        <td>{{ $d->kondisi_pinjam }}</td>
                        <td>{{ $d->kondisi_kembali ?? '-' }}</td>
                        <td>{{ $d->keterangan ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- APPROVAL --}}
@if(
    $peminjaman->status === 'pending' &&
    (
        is_null($peminjaman->id_guru_persetujuan) ||
        $peminjaman->id_guru_persetujuan == session('guru_id')
    )
)
<div class="card border-warning mb-3">
    <div class="card-body">
        <h6 class="mb-3 text-warning">
            <i class="fa-solid fa-circle-exclamation me-2"></i>
            Persetujuan Peminjaman
        </h6>

        <div class="d-flex flex-wrap gap-2">
            <form action="{{ route('guru.peminjaman.approve', $peminjaman->id) }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-success">
                    <i class="fa-solid fa-check me-1"></i>Setujui
                </button>
            </form>

            <form action="{{ route('guru.peminjaman.reject', $peminjaman->id) }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-danger">
                    <i class="fa-solid fa-xmark me-1"></i>Tolak
                </button>
            </form>
        </div>
    </div>
</div>
@endif

<a href="{{ route('guru.peminjaman.index') }}" class="btn btn-outline-secondary btn-sm">
    <i class="fa-solid fa-arrow-left me-1"></i>Kembali
</a>
@endsection
