@extends('layouts.guru')

@section('title', 'Peminjaman')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">
        <i class="fa-solid fa-box-open me-2"></i>Daftar Peminjaman
    </h4>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table id="peminjamanTable" class="table align-middle table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Kode</th>
                        <th>Tgl Pinjam</th>
                        <th>Tgl Kembali</th>
                        <th>Status</th>
                        <th class="text-center">Total</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($peminjaman as $p)
                    <tr>
                        <td class="fw-semibold">{{ $p->kode_peminjaman }}</td>
                        <td>{{ $p->tanggal_pinjam }}</td>
                        <td>{{ $p->tanggal_kembali ?? '-' }}</td>
                        <td>
                            <span class="badge
                                @if($p->status == 'pending') bg-warning
                                @elseif($p->status == 'disetujui') bg-success
                                @elseif($p->status == 'ditolak') bg-danger
                                @elseif($p->status == 'dipinjam') bg-primary
                                @elseif($p->status == 'dikembalikan') bg-secondary
                                @else bg-dark
                                @endif">
                                {{ strtoupper($p->status) }}
                            </span>
                        </td>
                        <td class="text-center">{{ $p->total_barang }}</td>
                        <td class="text-center">
                            <a href="{{ route('guru.peminjaman.detail', $p->id) }}"
                               class="btn btn-outline-primary btn-sm">
                                <i class="fa-solid fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#peminjamanTable').DataTable({
        responsive: true
    });
});
</script>
@endpush
