@extends('layouts.siswa')

@section('title', 'Detail Peminjaman')

@section('content')
<div class="container-fluid">

<div class="d-flex justify-content-between mb-3">
    <h3><i class="fa fa-box"></i> Detail Peminjaman</h3>
    <a href="{{ route('siswa.peminjaman.index') }}" class="btn btn-secondary btn-sm">
        Kembali
    </a>
</div>

<div class="card mb-3 shadow-sm">
    <div class="card-body">
        <p><strong>Kode:</strong> {{ $peminjaman->kode_peminjaman }}</p>
        <p><strong>Tanggal:</strong> {{ $peminjaman->tanggal_pinjam }} s/d {{ $peminjaman->tanggal_kembali }}</p>

        <span class="badge
            @if($peminjaman->status=='pending') bg-warning
            @elseif($peminjaman->status=='disetujui') bg-success
            @elseif($peminjaman->status=='dipinjam') bg-primary
            @elseif($peminjaman->status=='dikembalikan') bg-secondary
            @else bg-danger
            @endif">
            {{ strtoupper($peminjaman->status) }}
        </span>

        {{-- AMBIL BARANG --}}
        @if($peminjaman->status === 'disetujui')
        <hr>
        <form action="{{ route('siswa.peminjaman.ambil',$peminjaman->id) }}"
              method="POST"
              onsubmit="return confirm('Ambil barang sekarang?')">
            @csrf
            <button class="btn btn-primary">
                <i class="fa fa-hand-holding"></i> Ambil Barang
            </button>
        </form>
        @endif

        {{-- KEMBALIKAN --}}
        @if($peminjaman->status === 'dipinjam')
        <hr>
        <form action="{{ route('siswa.peminjaman.return',$peminjaman->id) }}"
              method="POST"
              onsubmit="return confirm('Kembalikan barang?')">
            @csrf
            <button class="btn btn-success">
                <i class="fa fa-rotate-left"></i> Kembalikan Barang
            </button>
        </form>
        @endif
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-header">Daftar Barang</div>
    <table class="table table-striped mb-0">
        <thead>
            <tr>
                <th>Barang</th>
                <th>Jumlah</th>
                <th>Kondisi</th>
            </tr>
        </thead>
        <tbody>
        @foreach($peminjaman->detail as $d)
            <tr>
                <td>{{ $d->barang->nama }}</td>
                <td>{{ $d->jumlah }}</td>
                <td>{{ $d->kondisi_pinjam }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>

</div>
@endsection
