@extends('layouts.siswa')

@section('title', 'Peminjaman Alat')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-3">
        <h3><i class="fa-solid fa-box"></i> Daftar Peminjaman</h3>
        <a href="{{ route('siswa.peminjaman.create') }}" class="btn btn-success btn-sm">
            <i class="fa-solid fa-plus"></i> Tambah
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="table-responsive">
            <table class="table table-striped align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Kode</th>
                        <th>Tgl Pinjam</th>
                        <th>Tgl Kembali</th>
                        <th>Status</th>
                        <th>Total</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($peminjaman as $pinjam)
                    <tr>
                        <td>{{ $pinjam->kode_peminjaman }}</td>
                        <td>{{ $pinjam->tanggal_pinjam }}</td>
                        <td>{{ $pinjam->tanggal_kembali }}</td>
                        <td>
                            <span class="badge
                                @if($pinjam->status=='pending') bg-warning
                                @elseif($pinjam->status=='disetujui') bg-success
                                @elseif($pinjam->status=='dipinjam') bg-primary
                                @elseif($pinjam->status=='dikembalikan') bg-secondary
                                @else bg-danger
                                @endif">
                                {{ strtoupper($pinjam->status) }}
                            </span>
                        </td>
                        <td>{{ $pinjam->total_barang }} item</td>
                        <td class="text-center">

                            {{-- DETAIL --}}
                            <a href="{{ route('siswa.peminjaman.detail',$pinjam->id) }}"
                               class="btn btn-outline-primary btn-sm">
                                <i class="fa fa-eye"></i>
                            </a>

                            {{-- AMBIL BARANG --}}
                            @if($pinjam->status === 'disetujui')
                            <form action="{{ route('siswa.peminjaman.ambil',$pinjam->id) }}"
                                  method="POST" class="d-inline"
                                  onsubmit="return confirm('Ambil barang sekarang?')">
                                @csrf
                                <button class="btn btn-primary btn-sm">
                                    <i class="fa fa-hand-holding"></i> Ambil
                                </button>
                            </form>
                            @endif

                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted py-4">
                            Belum ada peminjaman
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
