@extends('layouts.siswa')

@section('title','Tambah Penggunaan Bahan')

@section('content')
<div class="container-fluid">
    <div class="card shadow-sm">
        <div class="card-body">

            <h5 class="mb-3">
                <i class="fa-solid fa-flask"></i> Penggunaan Bahan Praktik
            </h5>

            <form method="POST" action="{{ route('siswa.penggunaan_bahan.store') }}">
                @csrf

                <div class="row g-2 mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Tanggal</label>
                        <input type="date" name="tanggal" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Guru Pengawas</label>
                        <select name="id_guru" class="form-select" required>
                            <option value="">-- Pilih Guru --</option>
                            @foreach($guru as $g)
                                <option value="{{ $g->id }}">{{ $g->nama }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Keterangan</label>
                        <input type="text" name="keterangan" class="form-control">
                    </div>
                </div>

                <hr>

                <div id="bahan-list">
                    <div class="row g-2 mb-2 bahan-item">
                        <div class="col-12 col-md-4">
                            <select name="bahan_id[]" class="form-select" required>
                                <option value="">-- Bahan --</option>
                                @foreach($bahan as $b)
                                    <option value="{{ $b->id }}">
                                        {{ $b->nama }} (stok: {{ $b->stok }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-6 col-md-2">
                            <input type="number" name="jumlah[]" step="0.01" max="10"
                                   class="form-control" placeholder="Max 10" required>
                        </div>

                        <div class="col-6 col-md-2">
                            <input type="text" name="satuan[]" value="pcs" class="form-control">
                        </div>

                        <div class="col-10 col-md-3">
                            <input type="text" name="keterangan_detail[]" class="form-control"
                                   placeholder="Keterangan">
                        </div>

                        <div class="col-2 col-md-1 text-end">
                            <button type="button" class="btn btn-danger remove-bahan">
                                <i class="fa-solid fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <button type="button" id="add-bahan" class="btn btn-outline-secondary btn-sm mb-3">
                    <i class="fa-solid fa-plus"></i> Tambah Bahan
                </button>

                <div class="d-flex gap-2">
                    <button class="btn btn-success">
                        <i class="fa-solid fa-save"></i> Simpan
                    </button>
                    <a href="{{ route('siswa.penggunaan_bahan.index') }}" class="btn btn-secondary">
                        Batal
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('click', e => {
    if (e.target.closest('#add-bahan')) {
        const item = document.querySelector('.bahan-item').cloneNode(true);
        item.querySelectorAll('input,select').forEach(i => i.value = '');
        document.getElementById('bahan-list').appendChild(item);
    }

    if (e.target.closest('.remove-bahan')) {
        const items = document.querySelectorAll('.bahan-item');
        if (items.length > 1) e.target.closest('.bahan-item').remove();
    }
});
</script>
@endpush
@endsection
