@extends('layouts.siswa')

@section('title', 'Detail Penggunaan Bahan')

@section('content')
<div class="container-fluid">

    <a href="{{ route('siswa.penggunaan_bahan.index') }}"
       class="btn btn-secondary btn-sm mb-3">
        <i class="fa-solid fa-arrow-left"></i> Kembali
    </a>

    <div class="card mb-3">
        <div class="card-body">
            <h4 class="mb-3">
                <i class="fa-solid fa-flask"></i> Detail Penggunaan
            </h4>

            <table class="table table-borderless">
                <tr>
                    <th width="200">Kode</th>
                    <td>: {{ $penggunaan->kode_penggunaan }}</td>
                </tr>
                <tr>
                    <th>Tanggal</th>
                    <td>: {{ $penggunaan->tanggal }}</td>
                </tr>
                <tr>
                    <th>Guru Pembimbing</th>
                    <td>: {{ $penggunaan->guru->nama ?? '-' }}</td>
                </tr>
                <tr>
                    <th>Keterangan</th>
                    <td>: {{ $penggunaan->keterangan ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h5 class="mb-3">
                <i class="fa-solid fa-boxes-stacked"></i> Bahan Digunakan
            </h5>

            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Bahan</th>
                        <th>Jumlah</th>
                        <th>Satuan</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($penggunaan->detail as $d)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $d->bahan->nama ?? '-' }}</td>
                        <td>{{ $d->jumlah }}</td>
                        <td>{{ $d->satuan }}</td>
                        <td>{{ $d->keterangan ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>

</div>
@endsection
